import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class TextBoxController extends JFrame {
	private TextBoxView view;
	private TextBoxModel model;
	private Container contentPane ;
	private JPanel buttonHolder ;
	private JTextField field1;
	private JButton compute;
	
	public TextBoxController() {
		contentPane = getContentPane() ;
		setTitle("Text Box");
		setSize(300, 200);
		buttonHolder = new JPanel() ;
		contentPane.add( buttonHolder, BorderLayout.SOUTH );

		buttonHolder.add( new JLabel("Input 1 "));
		field1= new JTextField(4);
		field1.setText("0");
		buttonHolder.add( field1 );
		buttonHolder.add( new JLabel( "   " ));
		compute= new JButton("Compute");
		compute.addActionListener(new ActionListener() {
			public void actionPerformed( ActionEvent e ) {
				model.setNumber( Double.parseDouble(field1.getText()));
				view.repaint();
			}
		});
		buttonHolder.add( compute );
		model= new TextBoxModel();
		view= new TextBoxView(model);
		view.setPreferredSize(new Dimension(100,100));
		contentPane.add(view, BorderLayout.CENTER );
		contentPane.repaint();
	}

	public static void main( String[] args ) {
		TextBoxController c= new TextBoxController();
		c.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE) ;
		c.setVisible(true) ;  
	}
}